﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<script runat="server">

    public class DuplikatContext : ContextBase {
    
         public DuplikatContext(Context cx) : base(cx) {
         }
    
         bool duplikat = true;
    
         [Caption("Duplikat")]
         public bool Duplikat {
             get { return duplikat; }
             set { duplikat = value; }
         }
    
    }

    // TASK: 2468. [4.3]
    ParametryWydrukuDokumentuTransportTekst parametry;

    // TASK: 2468. [4.3]
    [Context]
    public ParametryWydrukuDokumentuTransportTekst Parametry
    {
        get 
        { 
            return parametry; 
        }
        set 
        { 
            parametry = value; 
        }
    }
    
    static readonly string divider = "<pre>" + new string('-', 80) + "</pre>";
    static readonly string longdivider = "<small><pre>" + new string('-', 130) + "</pre></small>";
    
    void OnContextLoading(Object sender, EventArgs args) {
             DokumentHandlowy d = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];
             if (d==null) return;
    
             if (d.Stan!=StanDokumentuHandlowego.Bufor) {
                 if (!dc.Context.Contains(typeof(ParametryWydrukuDokumentuTransport)))
                     dc.AddRequiredType(typeof(DuplikatContext));
             }
    }
    
    bool duplikat = false;
    DokumentHandlowy dokument;
    CoreModule core;
    
    void OnContextLoad(Object sender, EventArgs args) {
         ///////////////////////////////////////////////
         // Inicjacja pól
         //
         if (dc.Context.Contains(typeof(DuplikatContext)))
             duplikat = ((DuplikatContext)dc[typeof(DuplikatContext)]).Duplikat;
    
         dokument = (DokumentHandlowy)dc[typeof(DokumentHandlowy)];
         core = CoreModule.GetInstance(dc);
    
        
        DokumentHandlowy dokumentOpakowań = null;
        foreach( RelacjaHandlowa r in dokument.NadrzedneRelacje ) {
            if( r.Typ == TypRelacjiHandlowej.HandlowoMagazynowa ) {
                
                foreach( RelacjaHandlowa rr in r.Nadrzedny.PodrzedneRelacje ) {
                    if( rr.Typ == TypRelacjiHandlowej.Kaucji )
                        dokumentOpakowań = rr.Podrzedny;
                }
            }
        }

        bool sąOpakowania = dokumentOpakowań != null;
        SectionOpakowania.Visible = sąOpakowania;
        if( sąOpakowania )
            GridOpakowania.DataSource = dokumentOpakowań.Pozycje;
        else
            GridOpakowania.DataSource = new PozycjaDokHandlowego[0];


         this.DataLabel7.EditValue = this.parametry.NrRejestracyjny;
        
         divider1.EditValue = divider;
         divider2.EditValue = longdivider;

         divider5.EditValue = divider;
         divider6.EditValue = longdivider;

         //Formatujemy informacj o podmiocie
        if (dokument.Kontrahent==null)
            DataRepeater2.Visible = false;
        else {
            DataLabel14.EditValue = multiLineEncode(dokument.DaneKontrahenta.NazwaFormatowana);
            DataLabel15.EditValue = HttpUtility.HtmlEncode(dokument.DaneKontrahenta.Adres.Linia1);
            DataLabel16.EditValue = HttpUtility.HtmlEncode(dokument.DaneKontrahenta.Adres.Linia2);
                
            DataLabel18.EditValue = multiLineEncode(dokument.DaneOdbiorcy.NazwaFormatowana);
            DataLabel19.EditValue = HttpUtility.HtmlEncode(dokument.DaneOdbiorcy.Adres.Linia1);
            DataLabel20.EditValue = HttpUtility.HtmlEncode(dokument.DaneOdbiorcy.Adres.Linia2);

            if (dokument.Wydruk.JestOdbiorcaMiejsceDostawy)
            {
                this._colOdbiorcaMiejsceDostawyNazwa.EditValue = multiLineEncode(dokument.OdbiorcaMiejsceDostawy.Nazwa);
                this._colOdbiorcaMiejsceDostawyAdresLinia1.EditValue = HttpUtility.HtmlEncode(dokument.OdbiorcaMiejsceDostawy.Adres.Linia1);
                this._colOdbiorcaMiejsceDostawyAdresLinia2.EditValue = HttpUtility.HtmlEncode(dokument.OdbiorcaMiejsceDostawy.Adres.Linia2);
            }

            string ktos = dokument.Definicja.DostawcaOdbiorca;
            kto2.EditValue = ktos+":"+new string('-', 81-ktos.Length);

            DataRepeater2.DataSource = new object [] { dokument };
            if (dokument.Wydruk.JestOdbiorca)
                ktos = "Kontrahent";
            else
                ktos = dokument.Definicja.DostawcaOdbiorca;

            kto.EditValue = ktos+":"+new string('-', 81-ktos.Length);
        }

   
         //Skadamy opis do dokumentu
         string opis = "";
         if (dokument.Opis!="")
             opis += "<br>" + dokument.Opis;
         if (dokument.Wydruk.OpisWydruku!="") {
             if (opis!="")
             opis += "<br>";
             opis += "<br>" + dokument.Wydruk.OpisWydruku;
         }
         Opis.EditValue = opis;
    
         //Formatujemy stopk dokumentu
         Stopka.EditValue =
         "<pre>" +
         Center(dokument.Session.Login.Operator.FullName, 40) + "| " + Center(dokument.Osoba, 38) + "<br>" +
         Left("", 40) + "|<br>" +
         Left("", 40) + "|<br>" +
         Center("..............................", 40) + "| " + Center("..............................", 38) + "<br>" +
         Center("Podpis osoby uprawnionej", 40) + "|  " + Center("Podpis Kierowcy", 38) + "<br>" +
         Center("do wystawienia dokumentu", 40) + "|  " + Center(parametry.Kierowca, 38) +
         "</pre>";
    
         Copyright.EditValue =
             "<small>" +
             "<pre>" +
             Right(dc.Copyright, 130) +
             "</pre>" +
             "</small>";
    
        init();
    }
    
    string multiLineEncode(string s) {
        string[] t = s.Split('\n');
        for (int i = t.Length; --i>=0; )
            t[i] = HttpUtility.HtmlEncode(t[i]);
        return string.Join("<br>&nbsp;&nbsp;&nbsp;&nbsp;", t);
    }
    
    int lc;
    void init() {
         //resetujemy licznik pozycji
         lc = 0;
    
         //Formatujemy nagwek dokumentu.
         //Moe by za kadym razem inny
    
         string dup = duplikat ? " <b>Duplikat</b>" : "";
    
         header.EditValue =
             "<pre>" +
             Left(core.Config.Firma.Pieczątka.Nazwa, 40) + "| " + Left(@"Specyfikacja transportowa", 20) + dup+ "<br>" +
             Left(core.Config.Firma.AdresSiedziby.Linia1, 40)    + "| <b>" + dokument.Numer + "</b><br>" +
             Left(core.Config.Firma.AdresSiedziby.Linia2, 40)    + "| <small>Data i miejsce wystawienia: " + dokument.Data + ", " + (dokument.Wydruk.JestOddzial ? dokument.Wydruk.PieczatkaOddziału.Adres.Miejscowosc : core.Config.Firma.AdresSiedziby.Miejscowosc) + "</small><br>" +
             Left("NIP: " + core.Config.Firma.Pieczątka.EuVAT , 40) + "| <small>Data operacji: " + dokument.DataOperacji + "</small>" +
             (!duplikat ? "" : "<br>" + Left("", 40) + "| <small>Data wystawienia duplikatu: " + Date.Today + "</small>") +
             "</pre>";
    
    }
    
   
    static string Center(object value, int len) {
         string ss = value.ToString();
         if (ss.Length>=len)
             return ss.Substring(0, len);
         int delta = len - ss.Length;
         int a = delta/2;
         return ss.PadRight(ss.Length+a).PadLeft(len);
    }
    
    static string Left(object value, int len) {
         string ss = value.ToString();
         if (ss.Length>len)
             return ss.Substring(0, len);
         return ss.PadRight(len);
    }
    
    static string Right(object value, int len) {
         string ss = value.ToString();
         if (ss.Length>len)
             return ss.Substring(0, len);
         return ss.PadLeft(len);
    }
    
    static string Clip(object value, int len) {
         string ss = value.ToString();
         if (ss.Length>len)
             return ss.Substring(0, len);
         return ss;
    }
    
    protected void TextGrid1_BeforeRow(object sender, RowEventArgs args) {
        PozycjaDokHandlowego pozycja = (PozycjaDokHandlowego)args.Row;
        colWaga.EditValue = pozycja.MasaJednostkowaNetto + " / " + pozycja.Towar.Jednostka;
    }
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title></title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="Sprzeda" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" oncontextload="OnContextLoad"></ea:datacontext>
        <ea:DataLabel id="header" runat="server"></ea:DataLabel>
        <br />
        <ea:DataLabel id="divider1" runat="server"></ea:DataLabel>
        <br />

        <% if (dokument.DokumentHandlowyNumer!="") { %>
        &nbsp;&nbsp;&nbsp;&nbsp;Dokument handlowy:
        <ea:DataLabel runat="server" Bold="False" DataMember="DokumentHandlowyNumer" ID="Datalabel1"></ea:DataLabel>
        z dnia: 
        <ea:DataLabel runat="server" Bold="False" DataMember="DokumentHandlowyData" ID="Datalabel2"></ea:DataLabel>
        <br/>
        <% } %>

        <% if (dokument.Magazyn!=null) { %>
        <% if (dokument.MagazynDo!=null) { %>
        &nbsp;&nbsp;&nbsp;&nbsp;Z magazynu:
        <ea:DataLabel runat="server" Bold="False" DataMember="Magazyn" ID="Datalabel3"></ea:DataLabel>
        do magazynu:
        <ea:DataLabel runat="server" Bold="False" DataMember="MagazynDo" ID="Datalabel4"></ea:DataLabel>
        <% } else { %>
        &nbsp;&nbsp;&nbsp;&nbsp;Magazyn:
        <ea:DataLabel runat="server" Bold="False" DataMember="Magazyn" ID="Datalabel5"></ea:DataLabel>
        <% } %>
        <br/>
        <% } %>
        &nbsp;&nbsp;&nbsp;&nbsp;Numer Rejestracyjny:
            <ea:DataLabel id="DataLabel7" runat="server" EncodeHTML="True" Font-Bold="True" Font-Underline="True" />
        <br />
        <ea:DataRepeater id="DataRepeater2" runat="server" Width="100%">
            <br />
        <i><ea:DataLabel id="kto" runat="server" Bold="False"></ea:DataLabel></i><br>
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel14" runat="server"></ea:datalabel><br>
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel15" runat="server"></ea:datalabel><br>
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel16" runat="server"></ea:datalabel><br>
        &nbsp;&nbsp;&nbsp;&nbsp;NIP:
        <ea:datalabel id="DataLabel17" runat="server" DataMember="DaneKontrahenta.EuVAT"></ea:datalabel><br>
        <% if (dokument.Wydruk.JestOdbiorca) { %>
        <i><ea:DataLabel id="kto2" runat="server" Bold="False"></ea:DataLabel></i><br>
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel18" runat="server"></ea:datalabel><br>
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel19" runat="server"></ea:datalabel><br>
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel20" runat="server"></ea:datalabel><br>
        &nbsp;&nbsp;&nbsp;&nbsp;NIP:
        <ea:datalabel id="DataLabel21" runat="server" DataMember="DaneOdbiorcy.EuVAT"></ea:datalabel><br>
        <% } %>
        <% if (dokument.Wydruk.JestOdbiorcaMiejsceDostawy) { %>
        <i>Miejsce dostawy:</i><br />
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="_colOdbiorcaMiejsceDostawyNazwa" runat="server"></ea:datalabel><br />
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="_colOdbiorcaMiejsceDostawyAdresLinia1" runat="server"></ea:datalabel><br />
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="_colOdbiorcaMiejsceDostawyAdresLinia2" runat="server"></ea:datalabel><br />
        <% } %>
        </ea:DataRepeater>
        <br />
        <ea:DataLabel id="divider2" runat="server" Bold="False"></ea:DataLabel>
        &nbsp;<br />
        <small>
        <ea:TextGrid ID="TextGrid1" runat="server" 
            RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" 
            DataMember="Wydruk.PozycjeRazem" Font-Size="Small" 
            onbeforerow="TextGrid1_BeforeRow">
            <Columns>
                <ea:GridColumn runat="server" Align="Right" Caption="Lp." DataMember="Lp" Width="3">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Kod towaru" DataMember="Towar.Kod"
                    EncodeHTML="True" Width="15" Align="Left">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Left" Caption="Nazwa towaru" DataMember="NazwaPierwszaLinia" Width="40" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Caption="Ilość" DataMember="ZmianaIlości.Value"
                    Width="7" RightBorder="None">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="jm." DataMember="Ilosc.Symbol" Width="6" Align="Right">
                </ea:GridColumn>
                <ea:GridColumn ID="colWaga" runat="server" Align="Left" Caption="Masa / Jednostkowa"
                    Width="17">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Masa netto" DataMember="MasaNetto"
                    Width="15">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Ilość opakowań" Width="15">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Masa brutto" DataMember="MasaBrutto" Width="15">
                </ea:GridColumn>
            </Columns>
          </ea:TextGrid>
            &nbsp;&nbsp;</small>
        <br />
        <small>Podsumowanie ilości: &nbsp;<ea:DataLabel ID="DataLabel6" Runat="server" Bold="False" DataMember="Wydruk.PodsumowanieIlości" Format="{0,92}" NonBreakSpace="True"></ea:DataLabel>
        </small>
        <br />

        <ea:section id="SectionOpakowania" runat="server">
            <br />
            <small>Opakowania:
            <ea:TextGrid ID="GridOpakowania" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" runat="server" Font-Size="Small">
                <Columns>
                    <ea:GridColumn DataMember="Towar.Nazwa" Caption="Nazwa opakowania" runat="server" Width="20"></ea:GridColumn>
                    <ea:GridColumn DataMember="Ilosc" Caption="Ilość" runat="server" Width="20"></ea:GridColumn>
                </Columns>    
            </ea:TextGrid>
            </small>
        </ea:section>



        <ea:DataLabel id="divider6" runat="server" Bold="False"></ea:DataLabel>
        <br />
        <ea:DataLabel id="Opis" runat="server" Bold="False"></ea:DataLabel>
        <br />
        <br />
        <ea:DataLabel id="divider5" runat="server" Bold="False"></ea:DataLabel>
        <br />
        <ea:DataLabel id="Stopka" runat="server" Bold="False"></ea:DataLabel>
        <br />
        <ea:DataLabel id="Copyright" runat="server" Bold="False"></ea:DataLabel>
        &nbsp;
    </form>
</body>
</html>

